/*
 * Decompiled with CFR 0.152.
 */
package tk.ufonet.rozvrhJava.subory;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tk.ufonet.rozvrhJava.jadro.Hodina;
import tk.ufonet.rozvrhJava.jadro.Rozvrh;
import tk.ufonet.rozvrhJava.subory.NacitajXMLReturn;

public class VytvorXML {
    public static void vytvorXML(File paSubor, Rozvrh paRozvrhInfo, ArrayList<Hodina> paRozvrh) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element koren = doc.createElement("rozvrh");
            doc.appendChild(koren);
            Element info = doc.createElement("info");
            koren.appendChild(info);
            Element nazov = doc.createElement("nazov");
            nazov.appendChild(doc.createTextNode(paRozvrhInfo.getNazov()));
            info.appendChild(nazov);
            Element popis = doc.createElement("popis");
            popis.appendChild(doc.createTextNode(paRozvrhInfo.getPopis()));
            info.appendChild(popis);
            Element data = doc.createElement("data");
            koren.appendChild(data);
            for (Hodina hodina : paRozvrh) {
                Element hod = doc.createElement("hodina");
                data.appendChild(hod);
                Attr attr = doc.createAttribute("den");
                attr.setValue(hodina.getDen() + "");
                hod.setAttributeNode(attr);
                attr = doc.createAttribute("cislo");
                attr.setValue(hodina.getCisloHodiny() + "");
                hod.setAttributeNode(attr);
                Element predmet = doc.createElement("predmet");
                predmet.appendChild(doc.createTextNode(hodina.getPredmet()));
                hod.appendChild(predmet);
                Element miestnost = doc.createElement("miestnost");
                miestnost.appendChild(doc.createTextNode(hodina.getMiestnost()));
                hod.appendChild(miestnost);
                Element ucitel = doc.createElement("ucitel");
                ucitel.appendChild(doc.createTextNode(hodina.getUcitel()));
                hod.appendChild(ucitel);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(paSubor);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException pce) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public static NacitajXMLReturn nacitajXML(File paSubor) {
        NacitajXMLReturn vystup = null;
        Rozvrh rozvrhInfo = null;
        ArrayList<Hodina> rozvrh = new ArrayList<Hodina>();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(paSubor);
            doc.getDocumentElement().normalize();
            String nazov = doc.getElementsByTagName("nazov").item(0).getTextContent();
            String popis = doc.getElementsByTagName("popis").item(0).getTextContent();
            rozvrhInfo = new Rozvrh(-1, nazov, popis);
            NodeList hodiny = doc.getElementsByTagName("hodina");
            for (int i = 0; i < hodiny.getLength(); ++i) {
                Element prvok = (Element)hodiny.item(i);
                int den = Integer.valueOf(prvok.getAttribute("den"));
                int cislo = Integer.valueOf(prvok.getAttribute("cislo"));
                String predmet = prvok.getElementsByTagName("predmet").item(0).getTextContent();
                String miestnost = prvok.getElementsByTagName("miestnost").item(0).getTextContent();
                String ucitel = prvok.getElementsByTagName("ucitel").item(0).getTextContent();
                Hodina hodina = new Hodina(den, cislo, predmet, miestnost, ucitel);
                rozvrh.add(hodina);
            }
            vystup = new NacitajXMLReturn(rozvrhInfo, rozvrh);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vystup;
    }
}

