/*
 * Decompiled with CFR 0.152.
 */
package tk.ufonet.rozvrhJava.subory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import tk.ufonet.rozvrhJava.jadro.Hodina;
import tk.ufonet.rozvrhJava.jadro.Rozvrh;

public class VytvorExcel {
    private final String[] DNI_V_TYZDNI = new String[]{"PO", "UT", "STR", "\u0160T", "PIA"};
    private File aSubor;

    public VytvorExcel(File paSubor) {
        this.aSubor = paSubor;
    }

    public void vytvorSubor(Rozvrh paRozvrhInfo, ArrayList<Hodina> paRozvrh) {
        int pocetHodin = this.maxPocetHodinZDat(paRozvrh);
        Hodina[][] poleHodin = this.pripravHodiny(paRozvrh, pocetHodin);
        HSSFWorkbook zosit = new HSSFWorkbook();
        HSSFSheet harok = zosit.createSheet("Rozvrh");
        harok.getPrintSetup().setLandscape(true);
        this.vytvorNazovPopisRozvrhu(harok, paRozvrhInfo, pocetHodin);
        this.vytvorHlavickuRozvrhu(harok, pocetHodin);
        this.vytvorTeloRozvrhu(harok, pocetHodin, poleHodin);
        this.upravVzhladRozvrhu(zosit, harok);
        this.oramujCelyRozvrh(pocetHodin, harok, zosit);
        HSSFRow riadok = harok.createRow(15);
        Cell bunka = riadok.createCell(0);
        bunka.setCellValue("Vytvoren\u00e9 programom Rozvrh v1.1.0");
        try {
            FileOutputStream out = new FileOutputStream(this.aSubor);
            zosit.write((OutputStream)out);
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void oramujCelyRozvrh(int paPocetHodin, HSSFSheet paHarok, HSSFWorkbook paZosit) {
        int i;
        this.oramuj(true, 2, 13, 0, paPocetHodin * 2, (Sheet)paHarok, (Workbook)paZosit);
        this.oramuj(true, 2, 3, 1, paPocetHodin * 2, (Sheet)paHarok, (Workbook)paZosit);
        this.oramuj(true, 4, 13, 0, 0, (Sheet)paHarok, (Workbook)paZosit);
        for (i = 5; i <= 11; ++i) {
            if (i % 2 != 1) continue;
            this.oramujDole(false, i, 0, paPocetHodin * 2, (Sheet)paHarok, (Workbook)paZosit);
        }
        for (i = 3; i <= paPocetHodin * 2; ++i) {
            if (i % 2 != 1) continue;
            this.oramujVlavo(false, 2, 13, i, (Sheet)paHarok, (Workbook)paZosit);
        }
    }

    private void upravVzhladRozvrhu(HSSFWorkbook paZosit, HSSFSheet paHarok) {
        HSSFFont standardnyFont = paZosit.createFont();
        standardnyFont.setFontHeightInPoints((short)10);
        standardnyFont.setFontName("Arial");
        standardnyFont.setColor(IndexedColors.BLACK.getIndex());
        standardnyFont.setBoldweight((short)400);
        standardnyFont.setItalic(false);
        HSSFFont pismoC12B = paZosit.createFont();
        pismoC12B.setFontHeightInPoints((short)12);
        pismoC12B.setFontName("Arial");
        pismoC12B.setColor(IndexedColors.BLACK.getIndex());
        pismoC12B.setBoldweight((short)700);
        HSSFFont pismoC10B = paZosit.createFont();
        pismoC10B.setFontHeightInPoints((short)10);
        pismoC10B.setFontName("Arial");
        pismoC10B.setColor(IndexedColors.BLACK.getIndex());
        pismoC10B.setBoldweight((short)700);
        HSSFCellStyle styl = paZosit.createCellStyle();
        styl.setAlignment((short)2);
        styl.setVerticalAlignment((short)1);
        styl.setFont((Font)standardnyFont);
        for (Row riadok : paHarok) {
            for (Cell bunka : riadok) {
                bunka.setCellStyle((CellStyle)styl);
            }
        }
        styl = paZosit.createCellStyle();
        styl.setAlignment((short)2);
        styl.setVerticalAlignment((short)1);
        styl.setFont((Font)pismoC12B);
        HSSFRow riadok1 = paHarok.getRow(0);
        riadok1.getCell(0).setCellStyle((CellStyle)styl);
        riadok1 = paHarok.getRow(2);
        for (Cell bunka : riadok1) {
            bunka.setCellStyle((CellStyle)styl);
        }
        for (int i = 4; i <= 13; ++i) {
            if (i % 2 != 0) continue;
            riadok1 = paHarok.getRow(i);
            riadok1.getCell(0).setCellStyle((CellStyle)styl);
        }
        styl = paZosit.createCellStyle();
        styl.setAlignment((short)2);
        styl.setVerticalAlignment((short)1);
        riadok1 = paHarok.getRow(3);
        styl.setFont((Font)pismoC10B);
        for (Cell bunka : riadok1) {
            bunka.setCellStyle((CellStyle)styl);
        }
    }

    private void vytvorTeloRozvrhu(HSSFSheet paHarok, int paPocetHodin, Hodina[][] paPoleHodin) {
        int cisloRiadku = 4;
        for (int cisloDna = 1; cisloDna <= 5; ++cisloDna) {
            HSSFRow riadok1 = paHarok.createRow(cisloRiadku);
            HSSFRow riadok2 = paHarok.createRow(cisloRiadku + 1);
            Cell bunka1 = riadok1.createCell(0);
            bunka1.setCellValue(this.DNI_V_TYZDNI[cisloDna - 1]);
            paHarok.addMergedRegion(new CellRangeAddress(cisloRiadku, cisloRiadku + 1, 0, 0));
            int cislo = 1;
            for (int i = 1; i < paPocetHodin * 2 + 1; ++i) {
                Hodina hodina = paPoleHodin[cisloDna - 1][cislo - 1];
                bunka1 = riadok1.createCell(i);
                Cell bunka2 = riadok2.createCell(i);
                if (hodina != null) {
                    if (i % 2 == 1) {
                        bunka2.setCellValue(hodina.getMiestnost());
                    } else {
                        bunka2.setCellValue(hodina.getUcitel());
                    }
                }
                if (i % 2 == 1) {
                    if (hodina != null) {
                        bunka1.setCellValue(hodina.getPredmet());
                    }
                    paHarok.addMergedRegion(new CellRangeAddress(cisloRiadku, cisloRiadku, i, i + 1));
                    continue;
                }
                ++cislo;
            }
            cisloRiadku += 2;
        }
    }

    private void vytvorHlavickuRozvrhu(HSSFSheet paHarok, int paPocetHodin) {
        Cell bunka;
        int i;
        HSSFRow riadok = paHarok.createRow(2);
        for (i = 1; i <= paPocetHodin * 2; ++i) {
            bunka = riadok.createCell(i);
            if (i % 2 != 1) continue;
            bunka.setCellValue((double)(i / 2 + 1));
            paHarok.addMergedRegion(new CellRangeAddress(2, 2, i, i + 1));
        }
        riadok = paHarok.createRow(3);
        for (i = 1; i <= paPocetHodin * 2; ++i) {
            bunka = riadok.createCell(i);
            if (i % 2 != 1) continue;
            bunka.setCellValue(this.dajCasTrvaniaHodiny(i / 2 + 1));
            paHarok.addMergedRegion(new CellRangeAddress(3, 3, i, i + 1));
        }
        paHarok.addMergedRegion(new CellRangeAddress(2, 3, 0, 0));
    }

    private void vytvorNazovPopisRozvrhu(HSSFSheet paHarok, Rozvrh paRozvrhInfo, int paPocetHodin) {
        HSSFRow riadok = paHarok.createRow(0);
        Cell bunka = riadok.createCell(0);
        bunka.setCellValue(paRozvrhInfo.getNazov() + " - " + paRozvrhInfo.getPopis());
        paHarok.addMergedRegion(new CellRangeAddress(0, 0, 0, paPocetHodin * 2));
    }

    private int maxPocetHodinZDat(ArrayList<Hodina> paRozvrh) {
        int stlpce = 0;
        for (Hodina hodina : paRozvrh) {
            if (hodina.getCisloHodiny() <= stlpce) continue;
            stlpce = hodina.getCisloHodiny();
        }
        return stlpce;
    }

    private Hodina[][] pripravHodiny(ArrayList<Hodina> paRozvrh, int paMaxPocetHodin) {
        Hodina[][] rozvrhPole = new Hodina[5][paMaxPocetHodin];
        Iterator<Hodina> iterator = paRozvrh.iterator();
        while (iterator.hasNext()) {
            Hodina hodina;
            rozvrhPole[hodina.getDen() - 1][hodina.getCisloHodiny() - 1] = hodina = iterator.next();
        }
        return rozvrhPole;
    }

    private String dajCasTrvaniaHodiny(int paCisloHodiny) {
        int zaciatok = 7;
        int cas = zaciatok + paCisloHodiny - 1;
        if (cas < 10) {
            return "0" + cas + ":00-0" + cas + ":50";
        }
        return "" + cas + ":00-" + cas + ":50";
    }

    private void oramuj(boolean paHrubo, int paPrvyRiadok, int paPoslednyRiadok, int paPrvyStlpec, int paPoslednyStlpec, Sheet paHarok, Workbook paZosit) {
        int styl = paHrubo ? 2 : 1;
        CellRangeAddress vyber = new CellRangeAddress(paPrvyRiadok, paPoslednyRiadok, paPrvyStlpec, paPoslednyStlpec);
        RegionUtil.setBorderTop((int)styl, (CellRangeAddress)vyber, (Sheet)paHarok, (Workbook)paZosit);
        RegionUtil.setTopBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)vyber, (Sheet)paHarok, (Workbook)paZosit);
        this.oramujDole(paHrubo, paPoslednyRiadok, paPrvyStlpec, paPoslednyStlpec, paHarok, paZosit);
        this.oramujVlavo(paHrubo, paPrvyRiadok, paPoslednyRiadok, paPrvyStlpec, paHarok, paZosit);
        RegionUtil.setBorderRight((int)styl, (CellRangeAddress)vyber, (Sheet)paHarok, (Workbook)paZosit);
        RegionUtil.setRightBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)vyber, (Sheet)paHarok, (Workbook)paZosit);
    }

    private void oramujDole(boolean paHrubo, int paPoslednyRiadok, int paPrvyStlpec, int paPoslednyStlpec, Sheet paHarok, Workbook paZosit) {
        int styl = paHrubo ? 2 : 1;
        CellRangeAddress vyber = new CellRangeAddress(paPoslednyRiadok, paPoslednyRiadok, paPrvyStlpec, paPoslednyStlpec);
        RegionUtil.setBorderBottom((int)styl, (CellRangeAddress)vyber, (Sheet)paHarok, (Workbook)paZosit);
        RegionUtil.setBottomBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)vyber, (Sheet)paHarok, (Workbook)paZosit);
    }

    private void oramujVlavo(boolean paHrubo, int paPrvyRiadok, int paPoslednyRiadok, int paPrvyStlpec, Sheet paHarok, Workbook paZosit) {
        int styl = paHrubo ? 2 : 1;
        CellRangeAddress vyber = new CellRangeAddress(paPrvyRiadok, paPoslednyRiadok, paPrvyStlpec, paPrvyStlpec);
        RegionUtil.setBorderLeft((int)styl, (CellRangeAddress)vyber, (Sheet)paHarok, (Workbook)paZosit);
        RegionUtil.setLeftBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)vyber, (Sheet)paHarok, (Workbook)paZosit);
    }
}

