/*
 * Decompiled with CFR 0.152.
 */
package tk.ufonet.rozvrhJava.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import tk.ufonet.rozvrhJava.jadro.Hodina;
import tk.ufonet.rozvrhJava.jadro.TypRozvrhu;
import tk.ufonet.rozvrhJava.parser.IParser;
import tk.ufonet.rozvrhJava.parser.VyhladanyRozvrh;

public class ParserUNIZA
implements IParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<VyhladanyRozvrh> vyhladajRozvrh(TypRozvrhu paTyp, String paHladanyRet) {
        ArrayList<VyhladanyRozvrh> vyhladaneHodnoty = new ArrayList<VyhladanyRozvrh>();
        String adresaVyhladania = "";
        try {
            adresaVyhladania = "http://vzdelavanie.uniza.sk/vzdelavanie/rozvrh_search.php?qs=" + (paTyp.ordinal() + 1) + "&q=" + URLEncoder.encode(paHladanyRet, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        InputStream input = null;
        HttpURLConnection connection = null;
        try {
            URL url = new URL(adresaVyhladania);
            connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            input = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"), 8);
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            String json = sb.toString();
            JSONArray jArray = new JSONArray(json);
            for (int i = 0; i < jArray.length(); ++i) {
                JSONObject jObject = jArray.getJSONObject(i);
                String popis = jObject.getString("label");
                String odkaz = jObject.getString("value");
                vyhladaneHodnoty.add(new VyhladanyRozvrh(popis, odkaz));
            }
        }
        catch (IOException e) {
            ArrayList<VyhladanyRozvrh> arrayList = null;
            return arrayList;
        }
        catch (JSONException e) {
            ArrayList<VyhladanyRozvrh> arrayList = null;
            return arrayList;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception squish) {}
        }
        return vyhladaneHodnoty;
    }

    @Override
    public ArrayList<Hodina> parsujRozvrh(TypRozvrhu paTyp, String paHladanyRet, VyhladanyRozvrh paVybratyRozvrh) {
        String adresaRozvrhu = "https://vzdelavanie.uniza.sk/vzdelavanie/" + paVybratyRozvrh.dajOdkaz() + "&sq=" + (paTyp.ordinal() + 1);
        ArrayList<Hodina> vystup = new ArrayList<Hodina>();
        String miestnost = null;
        try {
            Document doc = Jsoup.connect(adresaRozvrhu).get();
            Elements zoznamRiadkov = doc.select("div.rozvrh_tyzden");
            for (int i = 0; i < zoznamRiadkov.size(); ++i) {
                Element riadok = zoznamRiadkov.get(i);
                Elements zoznamBuniek = riadok.select("span.rozvrh_bloky");
                for (int j = 0; j < zoznamBuniek.size(); ++j) {
                    Element bunka = zoznamBuniek.get(j);
                    String html = bunka.html();
                    if (html.length() <= 0) continue;
                    String predmet = bunka.select("span.SRH_bold").get(1).text();
                    int br1 = html.indexOf("<br />");
                    int br2 = html.indexOf("<br />", br1 + 1);
                    int br3 = html.indexOf("<br />", br2 + 1);
                    String ucitel = html.substring(br1 + 6, br2);
                    miestnost = html.substring(br2 + 6, br3);
                    ucitel = Jsoup.parse(ucitel).text();
                    miestnost = Jsoup.parse(miestnost).text();
                    vystup.add(new Hodina(i + 1, j + 1, predmet, miestnost, ucitel));
                }
            }
            return vystup;
        }
        catch (IOException e) {
            return null;
        }
    }
}

