/*
 * Decompiled with CFR 0.152.
 */
package tk.ufonet.kurzy.core;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import tk.ufonet.kurzy.core.Kurz;
import tk.ufonet.kurzy.subory.KonfiguracnySubor;
import tk.ufonet.kurzy.subory.Luskac;
import tk.ufonet.kurzy.vynimky.NenacitanySuborException;
import tk.ufonet.kurzy.vynimky.VyhladanieKurzuException;

public class Tabulka {
    private KonfiguracnySubor aKonfiguracnySubor;
    private Luskac aLuskac;
    private JTable aTabulkaGUI;
    private JLabel aChybaGUI;
    private JTextField aDatumListkaGUI;
    private JSpinner aDatumGUI;
    private ArrayList<Kurz> aKurzy;
    private Component aDialog;
    private SimpleDateFormat aFormatDatumuUS;
    private SimpleDateFormat aFormatDatumuSK;

    public Tabulka(KonfiguracnySubor paKonfiguracnySubor, JTable paTabulkaGUI, JSpinner paDatumGUI, JLabel paChybaGUI, JTextField paDatumListkaGUI, String paNazovStiahnutehoSuboru) {
        this.aKonfiguracnySubor = paKonfiguracnySubor;
        this.aLuskac = new Luskac(paNazovStiahnutehoSuboru);
        this.aTabulkaGUI = paTabulkaGUI;
        this.aDatumGUI = paDatumGUI;
        this.aChybaGUI = paChybaGUI;
        this.aDatumListkaGUI = paDatumListkaGUI;
        this.aKurzy = new ArrayList();
        this.aFormatDatumuUS = new SimpleDateFormat("yyyy-MM-dd");
        this.aFormatDatumuSK = new SimpleDateFormat("d.M.yyyy");
    }

    public void vytvorKurzy() {
        this.aKurzy.clear();
        ArrayList<String> meny = this.aKonfiguracnySubor.dajMeny();
        for (String mena : meny) {
            this.aKurzy.add(new Kurz(mena));
        }
    }

    public void nacitajListok() {
        try {
            this.aLuskac.nacitajSubor();
            String vystup = this.aLuskac.dajDatumListka();
            Date datum = this.aFormatDatumuUS.parse(vystup);
            this.aDatumListkaGUI.setText(this.aFormatDatumuSK.format(datum));
            this.aChybaGUI.setVisible(false);
        }
        catch (NenacitanySuborException ex) {
        }
        catch (ParseException ex) {
            this.aDatumListkaGUI.setText("");
            this.aChybaGUI.setText("Chyba zmeny formatu datumu");
            this.aChybaGUI.setVisible(true);
        }
        catch (FileNotFoundException ex) {
            this.aDatumListkaGUI.setText("");
            this.aChybaGUI.setText("Kurzov\u00fd l\u00edstok neexistuje");
            this.aChybaGUI.setVisible(true);
        }
    }

    public void nacitajKurzy() {
        String datum = this.aFormatDatumuUS.format(this.aDatumGUI.getValue());
        try {
            for (Kurz kurz : this.aKurzy) {
                String vymennyKurz = this.aLuskac.dajKurz(kurz.dajMenu(), datum);
                kurz.zmenVymennyKurz(vymennyKurz);
            }
        }
        catch (NenacitanySuborException ex) {
            this.nacitajListok();
        }
        catch (VyhladanieKurzuException ex) {
            if (ex.dajChybu().equals("mena")) {
                JOptionPane.showMessageDialog(this.aDialog, "Mena " + ex.dajMenu() + " sa v kurzovom listku nenachadza.", "Chyba - Mena neexistuje", 0);
            }
            this.aDatumGUI.setValue(this.aDatumGUI.getPreviousValue());
            this.nacitajKurzy();
        }
    }

    public void vyplnTabulku() {
        DefaultTableModel model = (DefaultTableModel)this.aTabulkaGUI.getModel();
        int pocetRiadkov = this.aTabulkaGUI.getRowCount();
        for (int i = 0; i < pocetRiadkov; ++i) {
            model.removeRow(0);
        }
        for (Kurz kurz : this.aKurzy) {
            model.addRow(new Object[]{kurz.dajMenu(), kurz.dajVymennyKurz()});
        }
    }

    public void obnovTabulku() {
        this.vytvorKurzy();
        this.nacitajKurzy();
        this.vyplnTabulku();
    }
}

